/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.old.views;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.ide.syncing.core.old.ISyncResource;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Plugin;

public class SyncExporter {
    public void export(File logFile, ISyncResource[] items) {
        SimpleDateFormat df = new SimpleDateFormat();
        String date = df.format(new Date());
        Writer writer = null;
        try {
            try {
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                writer = new FileWriter(logFile, true);
                StringBuilder builder = new StringBuilder();
                builder.append("File Transfer Log: " + date + FileUtil.NEW_LINE);
                ISyncResource[] iSyncResourceArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    ISyncResource iSyncResource = iSyncResourceArray[n2];
                    if (iSyncResource.isSkipped()) {
                        builder.append(" " + iSyncResource.getPath().toString() + ": Skipped");
                    } else {
                        builder.append(" " + iSyncResource.getPath().toString() + ": " + SyncExporter.getSyncState(iSyncResource.getSyncState()));
                    }
                    builder.append('\n');
                    ++n2;
                }
                writer.write(builder.toString());
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)SyncingUIPlugin.getDefault(), (Throwable)e);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getSyncState(int state) {
        switch (state) {
            case 1: {
                return "Ignore";
            }
            case 2: {
                return "Items Match";
            }
            case 3: {
                return "CRC Mismatch";
            }
            case 4: {
                return "Uploaded";
            }
            case 5: {
                return "Downloaded";
            }
            case 6: {
                return "Uploaded";
            }
            case 7: {
                return "Downloaded";
            }
            case 8: {
                return "Incompatible File Types";
            }
            case 9: {
                return "Deleted on Client";
            }
            case 10: {
                return "Deleted on Server";
            }
        }
        return "Unknown";
    }
}

